/*
 * Decompiled with CFR 0.152.
 */
package de.androidpit.colorthief;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class MMCQ {
    private static final int SIGBITS = 5;
    private static final int RSHIFT = 3;
    private static final int MULT = 8;
    private static final int HISTOSIZE = 32768;
    private static final int VBOX_LENGTH = 32;
    private static final double FRACT_BY_POPULATION = 0.75;
    private static final int MAX_ITERATIONS = 1000;
    private static final Comparator<VBox> COMPARATOR_COUNT = new Comparator<VBox>(){

        @Override
        public int compare(VBox vBox, VBox vBox2) {
            return vBox.count(false) - vBox2.count(false);
        }
    };
    private static final Comparator<VBox> COMPARATOR_PRODUCT = new Comparator<VBox>(){

        @Override
        public int compare(VBox vBox, VBox vBox2) {
            int n = vBox.count(false);
            int n2 = vBox2.count(false);
            int n3 = vBox.volume(false);
            int n4 = vBox2.volume(false);
            if (n == n2) {
                return n3 - n4;
            }
            return n * n3 - n2 * n4;
        }
    };

    static int getColorIndex(int n, int n2, int n3) {
        return (n << 10) + (n2 << 5) + n3;
    }

    private static int[] getHisto(int[][] nArray) {
        int[] nArray2 = new int[32768];
        for (int[] nArray3 : nArray) {
            int n;
            int n2 = nArray3[0] >> 3;
            int n3 = nArray3[1] >> 3;
            int n4 = nArray3[2] >> 3;
            int n5 = n = MMCQ.getColorIndex(n2, n3, n4);
            nArray2[n5] = nArray2[n5] + 1;
        }
        return nArray2;
    }

    private static VBox vboxFromPixels(int[][] nArray, int[] nArray2) {
        int n = 1000000;
        int n2 = 0;
        int n3 = 1000000;
        int n4 = 0;
        int n5 = 1000000;
        int n6 = 0;
        for (int[] nArray3 : nArray) {
            int n7 = nArray3[0] >> 3;
            int n8 = nArray3[1] >> 3;
            int n9 = nArray3[2] >> 3;
            if (n7 < n) {
                n = n7;
            } else if (n7 > n2) {
                n2 = n7;
            }
            if (n8 < n3) {
                n3 = n8;
            } else if (n8 > n4) {
                n4 = n8;
            }
            if (n9 < n5) {
                n5 = n9;
                continue;
            }
            if (n9 <= n6) continue;
            n6 = n9;
        }
        return new VBox(n, n2, n3, n4, n5, n6, nArray2);
    }

    private static VBox[] medianCutApply(int[] nArray, VBox vBox) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        if (vBox.count(false) == 0) {
            return null;
        }
        if (vBox.count(false) == 1) {
            return new VBox[]{vBox.clone(), null};
        }
        int n6 = vBox.r2 - vBox.r1 + 1;
        int n7 = vBox.g2 - vBox.g1 + 1;
        int n8 = vBox.b2 - vBox.b1 + 1;
        int n9 = Math.max(Math.max(n6, n7), n8);
        int n10 = 0;
        int[] nArray2 = new int[32];
        Arrays.fill(nArray2, -1);
        int[] nArray3 = new int[32];
        Arrays.fill(nArray3, -1);
        if (n9 == n6) {
            for (n5 = vBox.r1; n5 <= vBox.r2; ++n5) {
                n4 = 0;
                for (n3 = vBox.g1; n3 <= vBox.g2; ++n3) {
                    for (n2 = vBox.b1; n2 <= vBox.b2; ++n2) {
                        n = MMCQ.getColorIndex(n5, n3, n2);
                        n4 += nArray[n];
                    }
                }
                nArray2[n5] = n10 += n4;
            }
        } else if (n9 == n7) {
            for (n5 = vBox.g1; n5 <= vBox.g2; ++n5) {
                n4 = 0;
                for (n3 = vBox.r1; n3 <= vBox.r2; ++n3) {
                    for (n2 = vBox.b1; n2 <= vBox.b2; ++n2) {
                        n = MMCQ.getColorIndex(n3, n5, n2);
                        n4 += nArray[n];
                    }
                }
                nArray2[n5] = n10 += n4;
            }
        } else {
            for (n5 = vBox.b1; n5 <= vBox.b2; ++n5) {
                n4 = 0;
                for (n3 = vBox.r1; n3 <= vBox.r2; ++n3) {
                    for (n2 = vBox.g1; n2 <= vBox.g2; ++n2) {
                        n = MMCQ.getColorIndex(n3, n2, n5);
                        n4 += nArray[n];
                    }
                }
                nArray2[n5] = n10 += n4;
            }
        }
        for (n5 = 0; n5 < 32; ++n5) {
            if (nArray2[n5] == -1) continue;
            nArray3[n5] = n10 - nArray2[n5];
        }
        return n9 == n6 ? MMCQ.doCut('r', vBox, nArray2, nArray3, n10) : (n9 == n7 ? MMCQ.doCut('g', vBox, nArray2, nArray3, n10) : MMCQ.doCut('b', vBox, nArray2, nArray3, n10));
    }

    private static VBox[] doCut(char c, VBox vBox, int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3;
        if (c == 'r') {
            n3 = vBox.r1;
            n2 = vBox.r2;
        } else if (c == 'g') {
            n3 = vBox.g1;
            n2 = vBox.g2;
        } else {
            n3 = vBox.b1;
            n2 = vBox.b2;
        }
        VBox vBox2 = null;
        VBox vBox3 = null;
        for (int i = n3; i <= n2; ++i) {
            int n4;
            if (nArray[i] <= n / 2) continue;
            vBox2 = vBox.clone();
            vBox3 = vBox.clone();
            for (n4 = (var7_10 = i - n3) <= (var8_11 = n2 - i) ? Math.min(n2 - 1, i + var8_11 / 2 ^ 0xFFFFFFFF ^ 0xFFFFFFFF) : Math.max(n3, (int)((double)(i - 1) - (double)var7_10 / 2.0) ^ 0xFFFFFFFF ^ 0xFFFFFFFF); n4 < 0 || nArray[n4] <= 0; ++n4) {
            }
            int n5 = nArray2[n4];
            while (n5 == 0 && n4 > 0 && nArray[n4 - 1] > 0) {
                n5 = nArray2[--n4];
            }
            if (c == 'r') {
                vBox2.r2 = n4;
                vBox3.r1 = n4 + 1;
            } else if (c == 'g') {
                vBox2.g2 = n4;
                vBox3.g1 = n4 + 1;
            } else {
                vBox2.b2 = n4;
                vBox3.b1 = n4 + 1;
            }
            return new VBox[]{vBox2, vBox3};
        }
        throw new RuntimeException("VBox can't be cut");
    }

    public static CMap quantize(int[][] nArray, int n) {
        if (nArray.length == 0 || n < 2 || n > 256) {
            return null;
        }
        int[] nArray2 = MMCQ.getHisto(nArray);
        VBox vBox = MMCQ.vboxFromPixels(nArray, nArray2);
        ArrayList<VBox> arrayList = new ArrayList<VBox>();
        arrayList.add(vBox);
        int n2 = (int)Math.ceil(0.75 * (double)n);
        MMCQ.iter(arrayList, COMPARATOR_COUNT, n2, nArray2);
        Collections.sort(arrayList, COMPARATOR_PRODUCT);
        MMCQ.iter(arrayList, COMPARATOR_PRODUCT, n - arrayList.size(), nArray2);
        Collections.reverse(arrayList);
        CMap cMap = new CMap();
        for (VBox vBox2 : arrayList) {
            cMap.push(vBox2);
        }
        return cMap;
    }

    private static void iter(List<VBox> list, Comparator<VBox> comparator, int n, int[] nArray) {
        int n2 = 1;
        int n3 = 0;
        while (n3 < 1000) {
            VBox vBox = list.get(list.size() - 1);
            if (vBox.count(false) == 0) {
                Collections.sort(list, comparator);
                ++n3;
                continue;
            }
            list.remove(list.size() - 1);
            VBox[] vBoxArray = MMCQ.medianCutApply(nArray, vBox);
            VBox vBox2 = vBoxArray[0];
            VBox vBox3 = vBoxArray[1];
            if (vBox2 == null) {
                throw new RuntimeException("vbox1 not defined; shouldn't happen!");
            }
            list.add(vBox2);
            if (vBox3 != null) {
                list.add(vBox3);
                ++n2;
            }
            Collections.sort(list, comparator);
            if (n2 >= n) {
                return;
            }
            if (n3++ <= 1000) continue;
            return;
        }
    }

    public static class CMap {
        public final ArrayList<VBox> vboxes = new ArrayList();

        public void push(VBox vBox) {
            this.vboxes.add(vBox);
        }

        public int[][] palette() {
            int n = this.vboxes.size();
            int[][] nArrayArray = new int[n][];
            for (int i = 0; i < n; ++i) {
                nArrayArray[i] = this.vboxes.get(i).avg(false);
            }
            return nArrayArray;
        }

        public int size() {
            return this.vboxes.size();
        }

        public int[] map(int[] nArray) {
            int n = this.vboxes.size();
            for (int i = 0; i < n; ++i) {
                VBox vBox = this.vboxes.get(i);
                if (!vBox.contains(nArray)) continue;
                return vBox.avg(false);
            }
            return this.nearest(nArray);
        }

        public int[] nearest(int[] nArray) {
            double d = Double.MAX_VALUE;
            int[] nArray2 = null;
            int n = this.vboxes.size();
            for (int i = 0; i < n; ++i) {
                int[] nArray3 = this.vboxes.get(i).avg(false);
                double d2 = Math.sqrt(Math.pow(nArray[0] - nArray3[0], 2.0) + Math.pow(nArray[1] - nArray3[1], 2.0) + Math.pow(nArray[2] - nArray3[2], 2.0));
                if (!(d2 < d)) continue;
                d = d2;
                nArray2 = nArray3;
            }
            return nArray2;
        }
    }

    public static class VBox {
        int r1;
        int r2;
        int g1;
        int g2;
        int b1;
        int b2;
        private final int[] histo;
        private int[] _avg;
        private Integer _volume;
        private Integer _count;

        public VBox(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
            this.r1 = n;
            this.r2 = n2;
            this.g1 = n3;
            this.g2 = n4;
            this.b1 = n5;
            this.b2 = n6;
            this.histo = nArray;
        }

        public String toString() {
            return "r1: " + this.r1 + " / r2: " + this.r2 + " / g1: " + this.g1 + " / g2: " + this.g2 + " / b1: " + this.b1 + " / b2: " + this.b2;
        }

        public int volume(boolean bl) {
            if (this._volume == null || bl) {
                this._volume = (this.r2 - this.r1 + 1) * (this.g2 - this.g1 + 1) * (this.b2 - this.b1 + 1);
            }
            return this._volume;
        }

        public int count(boolean bl) {
            if (this._count == null || bl) {
                int n = 0;
                for (int i = this.r1; i <= this.r2; ++i) {
                    for (int j = this.g1; j <= this.g2; ++j) {
                        for (int k = this.b1; k <= this.b2; ++k) {
                            int n2 = MMCQ.getColorIndex(i, j, k);
                            n += this.histo[n2];
                        }
                    }
                }
                this._count = n;
            }
            return this._count;
        }

        public VBox clone() {
            return new VBox(this.r1, this.r2, this.g1, this.g2, this.b1, this.b2, this.histo);
        }

        public int[] avg(boolean bl) {
            if (this._avg == null || bl) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                for (int i = this.r1; i <= this.r2; ++i) {
                    for (int j = this.g1; j <= this.g2; ++j) {
                        for (int k = this.b1; k <= this.b2; ++k) {
                            int n5 = MMCQ.getColorIndex(i, j, k);
                            int n6 = this.histo[n5];
                            n += n6;
                            n2 = (int)((double)n2 + (double)n6 * ((double)i + 0.5) * 8.0);
                            n3 = (int)((double)n3 + (double)n6 * ((double)j + 0.5) * 8.0);
                            n4 = (int)((double)n4 + (double)n6 * ((double)k + 0.5) * 8.0);
                        }
                    }
                }
                this._avg = n > 0 ? new int[]{~(~(n2 / n)), ~(~(n3 / n)), ~(~(n4 / n))} : new int[]{~(~(8 * (this.r1 + this.r2 + 1) / 2)), ~(~(8 * (this.g1 + this.g2 + 1) / 2)), ~(~(8 * (this.b1 + this.b2 + 1) / 2))};
            }
            return this._avg;
        }

        public boolean contains(int[] nArray) {
            int n = nArray[0] >> 3;
            int n2 = nArray[1] >> 3;
            int n3 = nArray[2] >> 3;
            return n >= this.r1 && n <= this.r2 && n2 >= this.g1 && n2 <= this.g2 && n3 >= this.b1 && n3 <= this.b2;
        }
    }
}

