/*
 * Decompiled with CFR 0.152.
 */
package de.androidpit.colorthief;

import de.androidpit.colorthief.MMCQ;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.util.Arrays;

public class ColorThief {
    private static final int DEFAULT_QUALITY = 10;
    private static final boolean DEFAULT_IGNORE_WHITE = true;

    public static int[] getColor(BufferedImage bufferedImage) {
        int[][] nArray = ColorThief.getPalette(bufferedImage, 5);
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = nArray[0];
        return nArray2;
    }

    public static int[] getColor(BufferedImage bufferedImage, int n, boolean bl) {
        int[][] nArray = ColorThief.getPalette(bufferedImage, 5, n, bl);
        if (nArray == null) {
            return null;
        }
        int[] nArray2 = nArray[0];
        return nArray2;
    }

    public static int[][] getPalette(BufferedImage bufferedImage, int n) {
        MMCQ.CMap cMap = ColorThief.getColorMap(bufferedImage, n);
        if (cMap == null) {
            return null;
        }
        return cMap.palette();
    }

    public static int[][] getPalette(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        MMCQ.CMap cMap = ColorThief.getColorMap(bufferedImage, n, n2, bl);
        if (cMap == null) {
            return null;
        }
        return cMap.palette();
    }

    public static MMCQ.CMap getColorMap(BufferedImage bufferedImage, int n) {
        return ColorThief.getColorMap(bufferedImage, n, 10, true);
    }

    public static MMCQ.CMap getColorMap(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        int[][] nArray;
        switch (bufferedImage.getType()) {
            case 5: 
            case 6: {
                nArray = ColorThief.getPixelsFast(bufferedImage, n2, bl);
                break;
            }
            default: {
                nArray = ColorThief.getPixelsSlow(bufferedImage, n2, bl);
            }
        }
        MMCQ.CMap cMap = MMCQ.quantize(nArray, n);
        return cMap;
    }

    private static int[][] getPixelsFast(BufferedImage bufferedImage, int n, boolean bl) {
        int n2;
        DataBufferByte dataBufferByte = (DataBufferByte)bufferedImage.getRaster().getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n3 = bufferedImage.getWidth() * bufferedImage.getHeight();
        int n4 = bufferedImage.getType();
        switch (n4) {
            case 5: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 4;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + n4);
            }
        }
        int n5 = n3 * n2;
        if (n5 != byArray.length) {
            throw new IllegalArgumentException("(expectedDataLength = " + n5 + ") != (pixels.length = " + byArray.length + ")");
        }
        int n6 = (n3 + n - 1) / n;
        int n7 = 0;
        int[][] nArrayArray = new int[n6][];
        switch (n4) {
            case 5: {
                for (int i = 0; i < n3; i += n) {
                    int n8 = i * 3;
                    int n9 = byArray[n8] & 0xFF;
                    int n10 = byArray[n8 + 1] & 0xFF;
                    int n11 = byArray[n8 + 2] & 0xFF;
                    if (bl && n11 > 250 && n10 > 250 && n9 > 250) continue;
                    nArrayArray[n7] = new int[]{n11, n10, n9};
                    ++n7;
                }
                break;
            }
            case 6: {
                for (int i = 0; i < n3; i += n) {
                    int n12 = i * 4;
                    int n13 = byArray[n12] & 0xFF;
                    int n14 = byArray[n12 + 1] & 0xFF;
                    int n15 = byArray[n12 + 2] & 0xFF;
                    int n16 = byArray[n12 + 3] & 0xFF;
                    if (n13 < 125 || bl && n16 > 250 && n15 > 250 && n14 > 250) continue;
                    nArrayArray[n7] = new int[]{n16, n15, n14};
                    ++n7;
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type: " + n4);
            }
        }
        return (int[][])Arrays.copyOfRange(nArrayArray, 0, n7);
    }

    private static int[][] getPixelsSlow(BufferedImage bufferedImage, int n, boolean bl) {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = n2 * n3;
        int n5 = (n4 + n - 1) / n;
        int n6 = 0;
        int[][] nArrayArray = new int[n5][];
        for (int i = 0; i < n4; i += n) {
            int n7 = i / n2;
            int n8 = i % n2;
            int n9 = bufferedImage.getRGB(n8, n7);
            int n10 = n9 >> 16 & 0xFF;
            int n11 = n9 >> 8 & 0xFF;
            int n12 = n9 & 0xFF;
            if (bl && n10 > 250 && n10 > 250 && n10 > 250) continue;
            nArrayArray[n6] = new int[]{n10, n11, n12};
            ++n6;
        }
        return (int[][])Arrays.copyOfRange(nArrayArray, 0, n6);
    }
}

